#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

char *p3_to_json(const char *msg);

/**
 * # Safety
 *
 * convert p3 binary data to JSON for jvm based languages
 */
jstring Java_com_skoky_AmmcBridge_p3_1to_1json(JNIEnv env, JClass, JString p3_bin);

/**
 * # Safety
 *
 * converts p3 network response to json fo rjvm languages
 */
jstring Java_com_skoky_AmmcBridge_p3_1network_1to_1json(JNIEnv env, JClass, JString p3_bin);

/**
 * # Safety
 *
 * encodes json message to p3 hex binary
 */
jstring Java_com_skoky_AmmcBridge_encode(JNIEnv env, JClass, JString json_str);

/**
 * # Safety
 *
 * converts P3 time to millis
 */
jstring Java_com_skoky_AmmcBridge_time_1to_1millis(JNIEnv env, JClass, JString str_time);

/**
 * # Safety
 *
 * returns p3 lib version
 */
jstring Java_com_skoky_AmmcBridge_version(JNIEnv env, JClass);
